/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.schematics.SchematicWrapper;

public class CmdSchematics
extends CommandNoppesBase {
    @Override
    public int func_82362_a() {
        return 2;
    }

    @CommandNoppesBase.SubCommand(desc="Build the schematic", usage="<name> [rotation] [[world:]x,y,z]]", permission=2)
    public void build(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String name = args[0];
        SchematicWrapper schem = SchematicController.Instance.load(name);
        if (schem == null) {
            throw new CommandException("Unknown schematic: " + name, new Object[0]);
        }
        this.sendMessage(sender, "width: " + schem.schema.getWidth() + ", length: " + schem.schema.getLength() + ", height: " + schem.schema.getHeight(), new Object[0]);
        BlockPos pos = sender.func_180425_c();
        World world = sender.func_130014_f_();
        int rotation = 0;
        if (args.length > 1) {
            try {
                rotation = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                LogWriter.error(e);
            }
        }
        if (args.length > 2) {
            String[] par;
            String location = args[2];
            if (location.contains(":")) {
                par = location.split(":");
                location = par[1];
                world = this.getWorld(server, par[0]);
                if (world == null) {
                    throw new CommandException("\"" + par[0] + "\" is an unknown world", new Object[0]);
                }
            }
            if (location.contains(",")) {
                par = location.split(",");
                if (par.length != 3) {
                    throw new CommandException("Location should be x,y,z. Length: " + par.length, new Object[0]);
                }
                try {
                    pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])par, (int)0, (boolean)false);
                }
                catch (NumberInvalidException e) {
                    throw new CommandException("Location should be in numbers " + location, new Object[0]);
                }
            }
        }
        if (pos.func_177958_n() == 0 && pos.func_177956_o() == 0 && pos.func_177952_p() == 0) {
            throw new CommandException("Location needed - " + pos, new Object[0]);
        }
        schem.init(pos, world, rotation);
        SchematicController.Instance.build(schem, sender);
    }

    @Override
    public String getDescription() {
        return "Schematic operation";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "schema";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender par1, @Nonnull String[] args, BlockPos pos) {
        if (args[0].equalsIgnoreCase("build") && args.length == 2) {
            List<String> list = SchematicController.Instance.list();
            return CommandBase.func_71530_a((String[])args, (String[])list.toArray(new String[0]));
        }
        return new ArrayList<String>();
    }

    public World getWorld(MinecraftServer server, String t) {
        for (WorldServer w : server.field_71305_c) {
            if (w == null || !(w.field_73011_w.getDimension() + "").equalsIgnoreCase(t)) continue;
            return w;
        }
        return null;
    }

    @CommandNoppesBase.SubCommand(desc="Gives info about the current build", permission=2)
    public void info(MinecraftServer server, ICommandSender sender, String[] args) {
        SchematicController.Instance.info(sender);
    }

    @CommandNoppesBase.SubCommand(desc="Lists available schematics", permission=2)
    public void list(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        List<String> list = SchematicController.Instance.list();
        if (list.isEmpty()) {
            throw new CommandException("No available schematics " + list, new Object[0]);
        }
        StringBuilder s = new StringBuilder();
        for (String file : list) {
            s.append(file).append(", ");
        }
        this.sendMessage(sender, s.toString(), new Object[0]);
    }

    @CommandNoppesBase.SubCommand(desc="Stops the current build", permission=2)
    public void stop(MinecraftServer server, ICommandSender sender, String[] args) {
        SchematicController.Instance.stop(sender);
    }
}

